/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class VWSplashWindow
extends JWindow
implements Runnable {
    private static final int NUM_IMAGES = 2;
    private static final String[] IMAGE_NAMES = new String[]{"applet_splash_screen", "splash_screen"};
    private ImageIcon m_splashIcon = null;
    private IVWSplashWindowListener m_listener = null;
    private int m_nSplashTimeInMilliseconds = 0;
    private Thread m_splasherThread = null;
    private JLabel m_iconLabel = null;
    private JLabel m_status = null;
    private JLabel m_message = null;

    public VWSplashWindow(Frame parent) {
        super(parent);
        this.init();
    }

    public void start(IVWSplashWindowListener listener, int nSplashTimeInMilliseconds) {
        this.setVisible(true);
        this.m_listener = listener;
        this.m_nSplashTimeInMilliseconds = nSplashTimeInMilliseconds;
        this.m_splasherThread = new Thread((Runnable)this, "VWSplashWindow");
        this.m_splasherThread.start();
        Thread.yield();
    }

    public void setStatus(String status) {
        this.updateStatus(status, null);
    }

    public void setStatus(String status, String message) {
        this.updateStatus(status, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResources() {
        this.m_splashIcon = null;
        this.m_listener = null;
        this.m_iconLabel = null;
        this.m_status = null;
        this.m_message = null;
        if (this.m_splasherThread != null) {
            try {
                this.m_splasherThread.join();
            }
            catch (InterruptedException ex) {
                VWDebug.logException(ex);
            }
            finally {
                this.m_splasherThread = null;
            }
        }
        this.getContentPane().removeAll();
        this.removeAll();
        this.dispose();
    }

    public void run() {
        try {
            if (this.m_listener != null) {
                this.m_listener.startProcessing();
            }
            Thread.sleep(this.m_nSplashTimeInMilliseconds);
        }
        catch (InterruptedException iex) {
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.dispose();
    }

    private void init() {
        int nWidth = 300;
        int nHeight = 200;
        try {
            JPanel panel = new JPanel(new BorderLayout(1, 1));
            panel.setBorder(BorderFactory.createBevelBorder(0));
            for (int nIndex = 0; nIndex < 2; ++nIndex) {
                this.m_splashIcon = this.getSplashIcon(IMAGE_NAMES[nIndex], nIndex == 1);
                if (this.m_splashIcon != null) break;
            }
            if (this.m_splashIcon != null) {
                int[] pixels;
                PixelGrabber pg;
                this.m_iconLabel = new JLabel(this.m_splashIcon);
                nWidth = this.m_splashIcon.getIconWidth();
                nHeight = this.m_splashIcon.getIconHeight() + 20;
                Image image = this.m_splashIcon.getImage();
                if (image != null && (pg = new PixelGrabber(image, 0, nHeight - 40, 1, 1, pixels = new int[1], 0, 1)).grabPixels() && (pg.getStatus() & 0x20) != 0) {
                    panel.setBackground(new Color(pixels[0]));
                }
            } else {
                this.m_iconLabel = new JLabel();
            }
            panel.add((Component)this.m_iconLabel, "Center");
            JPanel statusPanel = new JPanel(new BorderLayout());
            statusPanel.setBackground(Color.white);
            this.m_status = new JLabel();
            this.m_status.setHorizontalAlignment(0);
            statusPanel.add((Component)this.m_status, "First");
            this.m_message = new JLabel();
            this.m_message.setHorizontalAlignment(0);
            statusPanel.add((Component)this.m_message, "Last");
            panel.add((Component)statusPanel, "Last");
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.getContentPane().add((Component)panel, "Center");
            this.setSize(nWidth, nHeight);
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screenDim.width - nWidth) / 2, (screenDim.height - nHeight) / 2);
            this.setVisible(true);
        }
        catch (InterruptedException ex) {
            VWDebug.logException(ex);
        }
    }

    private ImageIcon getSplashIcon(String fileName, boolean bLogMessage) {
        Locale locale = Locale.getDefault();
        this.m_splashIcon = VWImageLoader.createImageIconNoMessage(fileName + "_" + locale.getLanguage() + "_" + locale.getCountry() + ".jpg");
        if (this.m_splashIcon == null) {
            this.m_splashIcon = VWImageLoader.createImageIconNoMessage(fileName + "_" + locale.getLanguage() + ".jpg");
            if (this.m_splashIcon == null) {
                this.m_splashIcon = VWImageLoader.createImageIconNoMessage(fileName + "_en_US.jpg");
            }
            if (bLogMessage && this.m_splashIcon == null) {
                System.out.println("[WARNING] Could not find " + fileName + " image file! Locale = " + locale);
            }
        }
        return this.m_splashIcon;
    }

    private void updateStatus(String status, String message) {
        if (status != null) {
            this.m_status.setText(status);
        } else {
            this.m_status.setText("");
        }
        if (message != null) {
            this.m_message.setText(message);
        } else {
            this.m_message.setText("");
        }
    }
}

